// normally the model is passed to the view instead of the view creating the model
define([
    'underscore',
    'moment',
    'marionette',
    'modules/form/section-view',
    'json!modules/new-appointment-request/views/requests/form.json',
],
function(
    _,
    moment,
    Marionette,
    SectionView,
    metadata
) {
    'use strict';

    return SectionView.extend({
        modelEvents: {},
        initialize: function(options) {
            var sectionName;
            var rules;
            this._sectionNumber = options.sectionNumber;
            this.model = options.model;
            sectionName = 'request-details-date-time-' + this._sectionNumber + '-section';
            if (options.isCCRequest) {
                rules = {
                    'formattedDate': true,
                    'dateInRange': true,
                    'uniqueDate': 'optionDate',
                };
                _.extend(metadata.sections[this._sectionNumber].questions[0].validate.rules, rules);
            } else {
                rules = {
                    'formattedDate': true,
                    'dateInRange': true,
                };
                metadata.sections[this._sectionNumber].questions[0].validate.rules = rules;
            }
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata);
            this.setCollectionMinMaxDates(options.minDate, options.maxDate);
            this.setTimeQuestionModel();

            // to do set this.model equal to options.model if defined
            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
        },
        setCollectionMinMaxDates: function(minDate, maxDate) {
            if (!_.isUndefined(minDate) && !_.isUndefined(maxDate)) {
                this.collection.each(function(model) {
                    if (model.get('type') === 'text-datepicker') {
                        model.set('min', minDate);
                        model.set('max', maxDate);
                    }
                });
            }
        },
        setTimeQuestionModel: function() {
            var optionDateId = 'optionDate' + this._sectionNumber;
            var optionTimeId = 'optionTime' + this._sectionNumber;
            var values = [];
            var self = this;

            if (this.collection.get(optionDateId).get('required')) {
                this.collection.get(optionTimeId).set('selected', 'AM');
                this.collection.get(optionTimeId).set('value', 'AM');
            }

            if (!this.model.get(optionTimeId)) {
                values = this.collection.get(optionTimeId).get('values')
                    .map(function(value) {
                        value.disabled = self._sectionNumber !== 1;
                        return value;
                    });
            } else {
                values = this.collection.get(optionTimeId).get('values')
                    .map(function(value) {
                        value.disabled = false;
                        return value;
                    });
            }
            this.collection.get(optionTimeId).set('values', values);
        },
        onRender: function() {
            this.initChildren();
            this.listenTo(this.model, 'change:optionDate' + this._sectionNumber, this.updateOptionTimeQuestion);
        },
        updateOptionTimeQuestion: function() {
            var $optionTime;
            var optionDateString;
            var optionTimeString;

            if (!this.isDestroyed()) {
                $optionTime = this.$el.find('.form-input-timepicker');
                optionDateString = 'optionDate' + this._sectionNumber;
                optionTimeString = 'optionTime' + this._sectionNumber;

                if (this.model.has(optionDateString) && this.model.get(optionDateString) !== '' &&
                    _.isDateString(this.model.get(optionDateString))) {
                    if ($optionTime.find('input').prop('disabled')) {
                        // this sets the default time value for the nonrequired times
                        this.model.set(optionTimeString, 'AM');
                        $optionTime.find('input[value="AM"]').prop('checked', true);
                        $optionTime.find('input')
                            .prop('disabled', false)
                            .parent('label')
                            .removeClass('ui-disabled');
                        // $optionTime.find('input').each().prop('disabled',false);
                    } // else already enabled
                } else {
                    $optionTime.find('input').prop('checked', false);
                    $optionTime.find('input')
                        .prop('disabled', true)
                        .parent('label')
                        .addClass('ui-disabled');
                }
            }
        },
        updateFDNS   el: function(model) {
            var id = model.get('id');
            var val = model.get('value');

            if (typeof gas !== 'undefined') {
                gas('send', 'event', 'veteran-appointment', 'appointment-request-time-selected', model.get('id'));
            }

            if (id.indexOf('optionDate') !== -1) {
                if (moment(val).isValid()) {
                    this.model.set(id, moment(val).format('MM/DD/YYYY'));
                } else {
                    this.model.unset(id);

                }
                // when: value has been set to empty string (e.g. erased)
                // then: we clear out time as well
                if (!val) {
                    this.model.unset('optionTime' + this._sectionNumber, '');
                }
            } else if (id.indexOf('optionTime') !== -1) {
                this.model.set(id, val);
            }
        },
    });
});
